/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.remote.io.server.impl;

import java.io.*;
import edu.emory.mathcs.util.remote.io.server.*;

/**
 * Server-side remote handle to an output stream.
 *
 * @see edu.emory.mathcs.util.remote.io.RemoteOutputStream
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public class RemoteOutputStreamSrvImpl implements RemoteOutputStreamSrv {
    final OutputStream out;
    public RemoteOutputStreamSrvImpl(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        this.out = out;
    }
    public void write(byte[] data) throws IOException {
        out.write(data);
    }
    public void flush() throws IOException {
        out.flush();
    }
    public void close() throws IOException {
        out.close();
    }
}
